

FFreqMQ <- function(dataf){

  dataf <- dataf[order(dataf$Protein),]
  
matches <-list()
matches2 <-list()
N_Count=c()
for (prot in unique(dataf$Protein)) {
  
  
  DataProtein <- dataf %>% filter(Protein==prot)
  df <-NULL
  matches <-NULL
  sumdata <-NULL
  matches2 <-NULL
  DataProteinPosition <- cbind.data.frame(DataProtein$Unique_scan, DataProtein$Sequence, DataProtein$Protein, DataProtein$PROTEIN_POS_NUM)
  colnames(DataProteinPosition) <- c("Unique_scan", "Peptide", "Protein", "PROTEIN_POS_NUM")
  DataProteinLocation <- cbind.data.frame(DataProtein$Unique_scan, DataProtein$PROTEIN_beg, DataProtein$PROTEIN_end)
  colnames(DataProteinLocation) <- c("Unique_scan", "PROTEIN_beg", "PROTEIN_end")
  
  DataProteinLocationND <- DataProteinLocation[!duplicated(DataProteinLocation$Unique_scan),]
  
  for (i in 1:length(DataProteinPosition$Unique_scan)) {
    value <-NULL
   
    for (j in 1:length(DataProteinLocationND$Unique_scan)) {
    
      value[j] <- dplyr::between(DataProteinPosition$PROTEIN_POS_NUM[i],DataProteinLocationND$PROTEIN_beg[j], DataProteinLocationND$PROTEIN_end[j])
      
      
    }
    matches[[i]] <-value
    df <- do.call("rbind",matches) #combine all vectors into a matrix
    sumdata<-rowSums(df)
   
  }
  
 
  N_Count = c(N_Count, sumdata)
  
}
counts <- as.data.frame(N_Count)

finalSet <- cbind.data.frame(dataf,counts)

return(finalSet)

}